/*
 * Melissa Data mdName API for Windows/Linux/Solaris
 * Copyright 1993-2007 Melissa Data Corporation.
 *
 * Public interface
 *
 * PRELIMINARY VERSION SUBJECT TO CHANGES
 */

#if !defined(MDNAME_H)
#define MDNAME_H

#if !defined(MDAPI)
	#if defined(_WIN32) || defined(_WIN64)
		#define MDAPI __declspec(dllimport)
	#else
		#define MDAPI
		#define __stdcall
	#endif
#endif

#if defined(__cplusplus) && !defined(mdCFORCE)

/*
 * C++ version of interface
 */
class MDAPI mdName
{
protected:
	struct mdName_ *I;
private:	/* disable implicit constructor and assignment */
	mdName(mdName &x);
	mdName& operator=(mdName &x);
public:
	enum ProgramStatus {
		NoError=0,
		ConfigFile=1,
		LicenseExpired=2,
		DatabaseExpired=3,
		Unknown=4
	};
	enum NameHints {
	  DefinitelyFull=1,
		VeryLikelyFull=2,
		ProbablyFull=3,
		Varying=4,
		ProbablyInverse=5,
		VeryLikelyInverse=6,
		DefinitelyInverse=7,
		MixedFirstName=8,
		MixedLastName=9
	};
	enum Population {
		Male=1,
		Mixed=2,
		Female=3
	};
	enum Aggression {
		Aggressive=1,
		Neutral=2,
		Conservative=3
	};
	enum Salutations {
		Formal=0,
		Informal=1,
		FirstLast=2,
		Slug=3,
		Blank=4
	};
	
	mdName();
	~mdName();

	/* Setup methods */
	void        SetPathToNameFiles(const char*);
	enum ProgramStatus InitializeDataFiles(void);
	const char* GetInitializeErrorString();

	int         SetLicenseString(const char*);

	const char* GetBuildNumber();
	const char* GetDatabaseDate();
	const char* GetDatabaseExpirationDate();
	const char* GetLicenseExpirationDate();

	/* Parsing properties */
	int 		SetPrimaryNameHint(enum NameHints);
	int 		SetSecondaryNameHint(enum NameHints);
	int	  	SetFirstNameSpellingCorrection(int);

	int 		SetGenderPopulation(enum Population);
	int 		SetGenderAggression(enum Aggression);

	/* Salutation Properties */
	int 		AddSalutation(enum Salutations);
	void		SetSalutationPrefix(const char*);
	void		SetSalutationSuffix(const char*);
	void		SetSalutationSlug(const char*);

	void    ClearProperties();

	/* Input for Parse */
	void    SetFullName(const char*);

	/* Input for Genderize */
	void		SetPrefix(const char*);
	void		SetPrefix2(const char*);
	void		SetFirstName(const char*);
	void		SetFirstName2(const char*);
	void		SetMiddleName(const char*);
	void		SetMiddleName2(const char*);
	void		SetSuffix(const char*);
	void		SetSuffix2(const char*);

	/* Along with Genderize input, additional input for Salutate */
	void		SetLastName(const char*);
	void		SetLastName2(const char*);

	/* Processing methods */
	int     Parse();
	int 		Genderize();
	int 		Salutate();

	/* Errors and status */
	const char* GetStatusCode();
	const char* GetErrorCode();
	const char* GetChangeCode();
	const char* GetDebugInfo(const char*); /* Internal use only */
	const char *GetResults();

	/* Output data */
	const char* GetPrefix();
	const char* GetPrefix2();
	const char* GetFirstName();
	const char* GetFirstName2();
	const char* GetMiddleName();
	const char* GetMiddleName2();
	const char* GetLastName();
	const char* GetLastName2();
	const char* GetSuffix();
	const char* GetSuffix2();
	const char* GetGender();
	const char* GetGender2();
	const char* GetSalutation();
};

#else

#if defined(__cplusplus)
	extern "C" {
#endif

enum mdNameProgramStatus {
	NoError=0,
	ConfigFile=1,
	LicenseExpired=2,
	DatabaseExpired=3,
	Unknown=4
};

enum mdNameNameHints {
  DefinitelyFull=1,
	VeryLikelyFull=2,
	ProbablyFull=3,
	Varying=4,
	ProbablyInverse=5,
	VeryLikelyInverse=6,
	DefinitelyInverse=7,
	MixedFirstName=8,
	MixedLastName=9
};

enum mdNamePopulation {
	Male=1,
	Mixed=2,
	Female=3
};

enum mdNameAggression {
	Aggressive=1,
	Neutral=2,
	Conservative=3
};

enum mdNameSalutations {
	Formal=0,
	Informal=1,
	FirstLast=2,
	Slug=3,
	Blank=4
};

typedef	void* mdName;

MDAPI mdName __stdcall mdNameCreate(void);
MDAPI void __stdcall mdNameDestroy(mdName);

/* Setup methods */
MDAPI void __stdcall mdNameSetPathToNameFiles(mdName, const char*);
MDAPI enum mdNameProgramStatus __stdcall mdNameInitializeDataFiles(mdName);
MDAPI const char* __stdcall mdNameGetInitializeErrorString(mdName);

MDAPI int __stdcall mdNameSetLicenseString(mdName, const char*);

MDAPI const char* __stdcall mdNameGetBuildNumber(mdName);
MDAPI const char* __stdcall mdNameGetDatabaseDate(mdName);
MDAPI const char* __stdcall mdNameGetDatabaseExpirationDate(mdName);
MDAPI const char* __stdcall mdNameGetLicenseExpirationDate(mdName);

/* Parsing properties */
MDAPI int __stdcall mdNameSetPrimaryNameHint(mdName, enum mdNameNameHints);
MDAPI int __stdcall mdNameSetSecondaryNameHint(mdName, enum mdNameNameHints);
MDAPI int __stdcall mdNameSetFirstNameSpellingCorrection(mdName, int);

MDAPI int __stdcall mdNameSetGenderPopulation(mdName, enum mdNamePopulation);
MDAPI int __stdcall mdNameSetGenderAggression(mdName, enum mdNameAggression);

/* Salutation Properties */
MDAPI int __stdcall mdNameAddSalutation(mdName, enum mdNameSalutations);
MDAPI void __stdcall mdNameSetSalutationPrefix(mdName, const char*);
MDAPI void __stdcall mdNameSetSalutationSuffix(mdName, const char*);
MDAPI void __stdcall mdNameSetSalutationSlug(mdName, const char*);

MDAPI void __stdcall mdNameClearProperties(mdName);

/* Input for Parse */
MDAPI void __stdcall mdNameSetFullName(mdName, const char*);

/* Input for Genderize */
MDAPI void __stdcall mdNameSetPrefix(mdName, const char*);
MDAPI void __stdcall mdNameSetPrefix2(mdName, const char*);
MDAPI void __stdcall mdNameSetFirstName(mdName, const char*);
MDAPI void __stdcall mdNameSetFirstName2(mdName, const char*);
MDAPI void __stdcall mdNameSetMiddleName(mdName, const char*);
MDAPI void __stdcall mdNameSetMiddleName2(mdName, const char*);
MDAPI void __stdcall mdNameSetSuffix(mdName, const char*);
MDAPI void __stdcall mdNameSetSuffix2(mdName, const char*);

/* Along with Genderize input, additional input for Salutate */
MDAPI	void __stdcall mdNameSetLastName(mdName, const char*);
MDAPI	void __stdcall mdNameSetLastName2(mdName, const char*);

/* Processing methods */
MDAPI int __stdcall mdNameParse(mdName);
MDAPI int __stdcall mdNameGenderize(mdName);
MDAPI int __stdcall mdNameSalutate(mdName);

/* Errors and status */
MDAPI const char* __stdcall mdNameGetStatusCode(mdName);
MDAPI const char* __stdcall mdNameGetErrorCode(mdName);
MDAPI const char* __stdcall mdNameGetChangeCode(mdName);
MDAPI const char* __stdcall mdNameGetResults(mdName);

/* Output data */
MDAPI const char* __stdcall mdNameGetPrefix(mdName);
MDAPI const char* __stdcall mdNameGetPrefix2(mdName);
MDAPI const char* __stdcall mdNameGetFirstName(mdName);
MDAPI const char* __stdcall mdNameGetFirstName2(mdName);
MDAPI const char* __stdcall mdNameGetMiddleName(mdName);
MDAPI const char* __stdcall mdNameGetMiddleName2(mdName);
MDAPI const char* __stdcall mdNameGetLastName(mdName);
MDAPI const char* __stdcall mdNameGetLastName2(mdName);
MDAPI const char* __stdcall mdNameGetSuffix(mdName);
MDAPI const char* __stdcall mdNameGetSuffix2(mdName);
MDAPI const char* __stdcall mdNameGetGender(mdName);
MDAPI const char* __stdcall mdNameGetGender2(mdName);
MDAPI const char* __stdcall mdNameGetSalutation(mdName);

#if defined(__cplusplus)
	}
#endif

#endif /* __cplusplus && (!mdCFORCE) */

#endif /* MDNAME_H */
